# Getting Started with Mastering Claude

**Welcome!** This guide will help you navigate the learning path based on your experience level and goals.

---

## Choose Your Starting Point

### 🚀 Complete Beginner (Never used Claude Code)

**Start here:** [Lesson 00: Quick Start](lessons/00-quick-start.md) (5 minutes)

This gets you a quick win and introduces the core concept.

**Then follow the full path:**
- Lesson 01: CLAUDE.md basics
- Lesson 02: Effective prompting
- Lesson 03: Plan mode
- Lesson 04: Memory system

**Time investment:** ~2 hours for lessons 00-04, then practice on real projects.

---

### 💼 Experienced Developer (Used Claude Code a few times)

**You probably know:** Basic prompting, file editing, running commands

**You should learn:**
1. [Lesson 01: CLAUDE.md](lessons/01-claude-md.md) - Most high-leverage habit
2. [Lesson 03: Plan Mode](lessons/03-plan-mode.md) - Prevent wasted work
3. [Lesson 08: Large Codebases](lessons/08-large-codebases.md) - Navigate efficiently
4. [Lesson 09: Parallelization](lessons/09-parallelization.md) - Work faster

**Skip:** Lesson 00 (too basic for you)

**Time investment:** ~1.5 hours, immediate productivity gains.

---

### 🔥 Power User (Using Claude Code daily)

**You already know:** CLAUDE.md, prompting, plan mode

**You should explore:**
1. [Lesson 05: Hooks](lessons/05-hooks.md) - Automate your workflow
2. [Lesson 06: MCP Servers](lessons/06-mcp-servers.md) - Extend capabilities
3. [Lesson 07: Custom Skills](lessons/07-skills.md) - Build reusable commands
4. [Lesson 10: Advanced Patterns](lessons/10-advanced-patterns.md) - Expert techniques

**Also grab:** [CHEAT-SHEET.md](CHEAT-SHEET.md) for quick reference

**Time investment:** 2-3 hours spread over a week. Implement as you learn.

---

## Learning Paths by Goal

### Goal: "I want to be productive ASAP"

**Fastest path to productivity:**
1. [00: Quick Start](lessons/00-quick-start.md) - 5 min
2. [01: CLAUDE.md](lessons/01-claude-md.md) - 20 min
3. [03: Plan Mode](lessons/03-plan-mode.md) - 15 min
4. [Bad vs Good Examples](examples/bad-claude-md.md) - 15 min

**Total: ~1 hour**

Then start using Claude Code on real work. Reference [Troubleshooting](lessons/11-troubleshooting.md) when stuck.

---

### Goal: "I want to master Claude Code completely"

**Complete mastery path:**

**Week 1: Foundations**
- Day 1: Lessons 00-01 (Quick Start + CLAUDE.md)
- Day 2: Lesson 02 (Prompting)
- Day 3: Lesson 03 (Plan Mode)
- Day 4: Lesson 04 (Memory)
- Day 5: Practice - work on a real project, refer to lessons as needed

**Week 2: Power Features**
- Day 1: Lesson 05 (Hooks)
- Day 2: Lesson 06 (MCP Servers)
- Day 3: Lesson 07 (Skills)
- Day 4: Implement hooks/skills for your workflow
- Day 5: Practice

**Week 3: Expert Level**
- Day 1: Lesson 08 (Large Codebases)
- Day 2: Lesson 09 (Parallelization)
- Day 3: Lesson 10 (Advanced Patterns)
- Day 4-5: Apply advanced patterns to a complex project

**Ongoing:** Reference [CHEAT-SHEET.md](CHEAT-SHEET.md) and [Troubleshooting](lessons/11-troubleshooting.md) as needed.

---

### Goal: "I want to fix a specific problem"

**Jump directly to the relevant lesson:**

| Problem | Lesson |
|---------|--------|
| Claude doesn't understand my project | [01: CLAUDE.md](lessons/01-claude-md.md) |
| Claude makes wrong assumptions | [02: Effective Prompting](lessons/02-effective-prompting.md) |
| Claude goes down the wrong path | [03: Plan Mode](lessons/03-plan-mode.md) |
| Claude forgets things between sessions | [04: Memory System](lessons/04-memory-system.md) |
| I want sound notifications | [05: Hooks](lessons/05-hooks.md) |
| Claude needs database/GitHub access | [06: MCP Servers](lessons/06-mcp-servers.md) |
| I repeat the same instructions | [07: Custom Skills](lessons/07-skills.md) |
| Hard to navigate large projects | [08: Large Codebases](lessons/08-large-codebases.md) |
| Claude is too slow | [09: Parallelization](lessons/09-parallelization.md) |
| Something broke / getting errors | [11: Troubleshooting](lessons/11-troubleshooting.md) |

---

## How to Use This Repository

### 📚 The Lessons (Core Learning)

Located in `/lessons/`. Read these in order. Do the exercises.

Each lesson is self-contained but builds on previous concepts.

### 📄 The Cheat Sheet (Daily Reference)

[CHEAT-SHEET.md](CHEAT-SHEET.md) - Print this. Keep it visible. Reference daily.

One-page summary of all commands, patterns, and best practices.

### 📋 The Templates (Starting Points)

Located in `/templates/`. Copy these to start new projects.

- `CLAUDE.md` - Complete project instructions template

### 🔍 The Examples (Learn by Comparison)

Located in `/examples/`. See what works vs what doesn't.

- `bad-claude-md.md` - Side-by-side comparisons of bad vs good CLAUDE.md patterns

### 🔧 Troubleshooting (When Stuck)

[lessons/11-troubleshooting.md](lessons/11-troubleshooting.md) - Common issues and fixes.

Reference this when something goes wrong.

---

## The Core Principle

**Every lesson teaches variations of one core idea:**

> Invest upfront in context (CLAUDE.md, memory, skills) → Claude performs better → Never repeat yourself → Productivity compounds over time

The best Claude Code users spend time setting up their environment once, then benefit from it in every session forever.

---

## Time Expectations

**Minimum viable mastery:** 1-2 hours
- Lessons 00, 01, 03
- Read the cheat sheet
- Practice on one real project

**Comfortable proficiency:** 3-4 hours
- Lessons 00-04, 08-09
- Review examples
- Set up CLAUDE.md for your main project

**Expert level:** 8-10 hours
- All lessons (00-11)
- Implement hooks and skills
- Set up MCP servers
- Practice advanced patterns

**Ongoing:** 5-10 minutes per week refining CLAUDE.md based on what you learn

---

## Study Tips

**Do the exercises.** Reading without practicing won't make you proficient.

**Apply immediately.** After each lesson, use it on real work. Theory → Practice → Mastery.

**Iterate on CLAUDE.md.** Your first CLAUDE.md will be basic. That's fine. Improve it every week.

**Ask Claude for help.** "Explain how plan mode works" or "Help me write a better CLAUDE.md for this project"

**Don't rush.** Better to master lessons 1-4 than to skim all 11.

---

## What Success Looks Like

After completing this curriculum, you should:

✅ Have a comprehensive CLAUDE.md for your main project
✅ Use plan mode automatically for non-trivial tasks
✅ Batch requests for efficiency
✅ Maintain useful project memory
✅ Have at least 2-3 custom skills
✅ Understand when to use MCP servers
✅ Know how to recover when Claude makes mistakes
✅ Be 3-5x more productive than when you started

---

## Questions?

- **Built-in help:** Type `/help` in Claude Code
- **Troubleshooting:** Check [Lesson 11](lessons/11-troubleshooting.md)
- **GitHub Issues:** https://github.com/anthropics/claude-code/issues

---

## Ready to Start?

**Complete beginners:** Go to [Lesson 00: Quick Start](lessons/00-quick-start.md)

**Everyone else:** Pick your path above and dive in.

The best time to start was when you first installed Claude Code. The second-best time is now.

Good luck! 🚀
