# Mastering Claude

A structured learning path for becoming an expert Claude Code user — available as a [live website](https://mastering-claude-code.com/) or plain Markdown files you can read anywhere.

---

## Read Online

**[mastering-claude-code.com](https://mastering-claude-code.com/)** — full interactive site with search, dark mode, progress tracking, and a downloadable offline bundle.

---

## Start Here

**New to this resource?** Read **[GETTING-STARTED.md](GETTING-STARTED.md)** to choose the right learning path for your experience level.

**In a hurry?** Jump to **[Lesson 00: Quick Start](lessons/00-quick-start.md)** for a 5-minute introduction.

**Daily user?** Grab the **[CHEAT-SHEET.md](CHEAT-SHEET.md)** for quick reference.

---

## Learning Path

Work through the lessons in order — each builds on the previous.

| # | Lesson | Topic |
|---|--------|-------|
| 00 | [**Quick Start**](lessons/00-quick-start.md) | **Get your first win in 5 minutes** |
| 01 | [CLAUDE.md & Project Instructions](lessons/01-claude-md.md) | Teaching Claude your rules |
| 02 | [Effective Prompting](lessons/02-effective-prompting.md) | How to communicate for best results |
| 03 | [Plan Mode & Approval Workflows](lessons/03-plan-mode.md) | Reviewing before Claude acts |
| 04 | [Memory System](lessons/04-memory-system.md) | Persistent knowledge across sessions |
| 05 | [Hooks](lessons/05-hooks.md) | Automating Claude's behavior |
| 06 | [MCP Servers](lessons/06-mcp-servers.md) | Extending Claude with tools |
| 07 | [Custom Skills / Slash Commands](lessons/07-skills.md) | Building your own /commands |
| 08 | [Large Codebases](lessons/08-large-codebases.md) | Navigating complex projects |
| 09 | [Parallelization & Efficiency](lessons/09-parallelization.md) | Getting Claude to work faster |
| 10 | [Advanced Patterns](lessons/10-advanced-patterns.md) | Expert-level techniques |
| 11 | [Troubleshooting](lessons/11-troubleshooting.md) | Fixing common issues |

---

## Key Principles (TL;DR)

1. **Invest in CLAUDE.md.** It's the highest-leverage thing you can do. Good instructions compound across every session.
2. **Use Plan Mode for anything non-trivial.** Review before Claude acts.
3. **Be specific, not vague.** "Fix the login bug" is worse than "The JWT token is not being refreshed on expiry in auth.ts."
4. **Let Claude parallelize.** Ask it to do multiple independent things at once.
5. **Memory is your friend.** Teach Claude your preferences so you never repeat yourself.
6. **Hooks automate the boring stuff.** Sound notifications, auto-formatting, git hygiene.
7. **MCP extends what's possible.** Give Claude access to your databases, APIs, browsers.

---

## Quick Reference

**[Cheat Sheet](CHEAT-SHEET.md)** — one-page reference of all essential commands and patterns.

### Built-in Commands
```
/help          - Claude Code help
/plan          - Enter plan mode
/memory        - View/edit memory
/settings      - Open settings
```

### Additional Resources
- **[Templates](templates/)** — starter templates for CLAUDE.md and other files
- **[Examples](examples/)** — bad vs good CLAUDE.md examples to learn from
- **[Exercises](exercises/)** — hands-on practice exercises
- **[Troubleshooting Guide](lessons/11-troubleshooting.md)** — fix common issues

---

## Repository Structure

```
├── lessons/          # 12 lesson markdown files (source of truth)
├── examples/         # Bad vs good CLAUDE.md examples
├── exercises/        # Practice exercises
├── templates/        # Starter CLAUDE.md templates
├── CHEAT-SHEET.md    # Quick reference
├── GETTING-STARTED.md
└── website/          # Static site (Vite + plain HTML/CSS/JS)
    ├── assets/       # CSS & JS
    ├── lessons/      # Generated HTML lessons
    ├── scripts/      # Build scripts (markdown→HTML, search index, sitemap, QA)
    ├── public/       # Static assets (favicon, robots.txt, sitemap, zip bundle)
    ├── netlify.toml  # Netlify deployment config
    └── vercel.json   # Vercel deployment config
```

## Deploying the Website

The site is a static build — deploy to Netlify, Vercel, or Cloudflare Pages.

**Build command:** `npm run build`
**Output directory:** `dist`

The build pipeline: converts markdown → HTML, generates search index, creates ZIP bundle, generates sitemap, runs Vite, then runs automated QA (103 checks).

```bash
cd website
npm install
npm run build
```
