# Examples

Real-world examples showing the difference between ineffective and effective Claude Code practices.

---

## What's Here

### [Bad vs Good CLAUDE.md](bad-claude-md.md)

**The most important resource for getting CLAUDE.md right.**

This file contains 8 side-by-side comparisons showing:
- ❌ What doesn't work (vague, wishful thinking, unusable)
- ✅ What does work (specific, actionable, enforceable)

Covers:
1. Project descriptions
2. Code style rules
3. Project structure
4. Development commands
5. Restrictions and forbidden patterns
6. Business context and domain terminology
7. Git workflow
8. Testing standards

**How to use it:**
1. Read through all 8 examples
2. Compare to your own CLAUDE.md
3. Find places where you're being vague (like the "bad" examples)
4. Rewrite them to be specific (like the "good" examples)

---

## Coming Soon

More examples to be added:
- Real-world CLAUDE.md files from different project types (API, frontend, mobile, etc.)
- Custom skills (slash commands) for common workflows
- Hook scripts for automation
- MCP server configurations

---

## Contributing Your Own Examples

If you have a particularly effective CLAUDE.md pattern or a "before/after" that dramatically improved Claude's performance, consider adding it here as an example for others.

The best examples:
- Show a clear before/after
- Explain *why* the "good" version works better
- Are specific to real-world scenarios
- Help others avoid common mistakes
