# Exercise 01: Write Your CLAUDE.md

## Goal
Create a meaningful CLAUDE.md for a real project you work on.

## Instructions

### Part A: Global CLAUDE.md (~/.claude/CLAUDE.md)

Open your global CLAUDE.md and add the following sections if they're missing:

1. **Communication preferences**
   - How verbose should Claude be?
   - Do you want code explanations or just code?
   - Any formatting preferences?

2. **Universal tool preferences**
   - Which package manager? (npm / yarn / pnpm / bun)
   - Which test runner?
   - Which formatter?

3. **Universal forbidden patterns**
   - At least 3 things you never want Claude to do in any project
   - Examples: "never add console.log", "never use var", "never commit without running tests"

4. **Commit format**
   - Do you use conventional commits?
   - Should commits be signed?
   - What's your preferred commit message style?

### Part B: Project CLAUDE.md

Pick a real project you're actively working on and create a `.claude/CLAUDE.md` or `CLAUDE.md` in the root with:

1. **Project description** — 1 paragraph
2. **Tech stack** — complete list
3. **Project structure** — key directories and what's in them
4. **Development commands** — how to run, test, build
5. **3+ coding rules** specific to this project
6. **3+ "never do this" rules** specific to this project

### Part C: Test It

Start a new Claude Code session in that project and ask:
> "Without looking at any files, tell me what you know about this project from CLAUDE.md."

See how well Claude can describe the project from your instructions alone. Fill in any gaps.

## Success Criteria

- [ ] Global CLAUDE.md has communication preferences, tool preferences, and universal rules
- [ ] Project CLAUDE.md has all 6 sections filled in
- [ ] Claude can accurately describe the project from CLAUDE.md alone
- [ ] You've committed CLAUDE.md to the project repo

## Reflection Questions

- What surprised you about what you chose to put in CLAUDE.md?
- What did you leave out that you later wished you'd included?
- How would a new team member benefit from your CLAUDE.md?
