# Exercise 02: Build Your First Skills Library

## Goal
Create at least 3 custom skills that you'll actually use in your regular workflow.

## Instructions

### Step 1: Identify Repetitive Prompts

Think about the last week of Claude interactions. What did you find yourself typing repeatedly? Common candidates:
- "Create a git commit following [your conventions]"
- "Review this code for security issues"
- "Write tests for this function"
- "Explain this code to me"
- "Check for performance issues"
- "Generate a PR description"

Write down your top 5 candidates.

### Step 2: Build Your Skills

Create these files in `~/.claude/commands/`:

**Required Skill 1: A git workflow skill**
Something you do with git regularly. Could be commit, PR creation, branch cleanup, standup prep, etc.

**Required Skill 2: A code quality skill**
Something about reviewing or improving code. Could be security review, performance analysis, test coverage check, etc.

**Required Skill 3: Your choice**
Whatever would save you the most time in your specific work.

### Step 3: Write Good Skill Files

Each skill file should have:
- **Clear outcome**: What will exist when the skill is done?
- **Specific steps**: Not "do a good review" but exact criteria
- **Output format**: What should Claude show you?
- **Edge cases**: What should Claude do if something is missing?

### Step 4: Test and Iterate

Use each skill 3 times. After each use, note:
- What worked well?
- What did Claude do wrong or misunderstand?
- What would have made the output more useful?

Refine the skill file based on your notes.

## Example Skill to Start With

Save this as `~/.claude/commands/commit.md` and customize it:

```markdown
Create a git commit for the currently staged changes.

1. Run `git diff --staged` to review what's staged
2. If nothing is staged, tell me and stop
3. Run `git log --oneline -3` to see recent commit style
4. Write a commit message following: [YOUR CONVENTION HERE]
   - [Your specific rules]
5. Create the commit
6. Show the commit hash and first line of the message

Do not push. Do not ask for confirmation.
```

## Success Criteria

- [ ] 3+ skill files created in ~/.claude/commands/
- [ ] Each skill has clear outcome, steps, and output format
- [ ] Each skill has been used at least 3 times
- [ ] Skills have been refined based on usage

## Stretch Goal

Build a project-specific skill in `.claude/commands/` for a task unique to one of your projects (like seeding test data, running a specific migration, generating API documentation, etc.).
