# Exercise 03: The Ralph Wiggum Rewrite Loop

## Goal
Practice the Ralph Wiggum Technique by taking vague prompts and rewriting them with enough explicit detail that there is only one way to fulfill them correctly.

## Background
The Ralph Wiggum Technique is about eliminating all ambiguity from a prompt. Every inference Claude has to make is a chance for it to infer the wrong thing. Your job is to leave nothing to inference.

## Instructions

For each of the three vague prompts below, rewrite it as a Ralph Wiggum prompt. Your rewritten prompt should:
- State every constraint explicitly
- Enumerate requirements as a numbered or bulleted list
- Specify the output format precisely
- Include at least one example or anti-example
- Include a "stop" condition (what Claude should do if it can't complete the task)

---

## Prompt 1: The Code Review

**Original (vague):**
> "Review this code and let me know if there are any issues."

**Your task:** Rewrite this as a Ralph Wiggum prompt for a Python code review that will be used in a production codebase review workflow. You care specifically about: correctness, security, and performance. You do NOT want style suggestions.

**Hints:**
- How should Claude format each issue it finds?
- What should it say if it finds no issues?
- Should it suggest refactors or only flag problems?
- How should it handle issues of different severity?

Write your rewritten prompt here:

```
[your prompt here]
```

---

## Prompt 2: The Documentation Generator

**Original (vague):**
> "Write documentation for my function."

**Your task:** Rewrite this as a Ralph Wiggum prompt for generating JSDoc-style documentation for a TypeScript function. The documentation will be added directly to the codebase — it needs to be precise and follow your team's conventions.

**Hints:**
- What sections are required (parameters, returns, throws, example)?
- What should Claude do about parameters with unclear types?
- How long should descriptions be?
- Should it document internal helper functions differently from exported functions?

Write your rewritten prompt here:

```
[your prompt here]
```

---

## Prompt 3: The Bug Report Summarizer

**Original (vague):**
> "Look at these error logs and tell me what's wrong."

**Your task:** Rewrite this as a Ralph Wiggum prompt for an automated bug triage system. The output will be inserted directly into a Jira ticket — it needs to be structured, not conversational.

**Hints:**
- What fields should the Jira ticket have?
- How should Claude handle logs it doesn't understand?
- What's the difference between a root cause and a symptom?
- Should Claude include raw log lines in the output?

Write your rewritten prompt here:

```
[your prompt here]
```

---

## Sample Solution: Prompt 1

Here is one valid rewrite of Prompt 1. Yours may differ — there's no single correct answer, only more or less explicit ones.

```
Review the Python code below for issues. For each issue you find:

1. Quote the exact line(s) that contain the issue (use the line number if visible)
2. Classify the issue as one of: CORRECTNESS, SECURITY, or PERFORMANCE
3. Explain the problem in one sentence
4. Show the corrected version

Rules:
- Review ONLY for correctness, security, and performance
- Do NOT suggest style improvements, variable renames, or refactors
- Do NOT add features or suggest architectural changes
- If an issue requires context you don't have (e.g., how a function is called), say so and skip it
- If you find no issues in a category, do not mention that category

If you find zero issues overall, respond with exactly: "No issues found."

Format each issue as:
---
Line: [line number or "unknown"]
Type: [CORRECTNESS | SECURITY | PERFORMANCE]
Problem: [one sentence]
Fix:
[corrected code block]
---
```

---

## Part B: The CLAUDE.md Addition

Take the best rules you discovered while doing Part A and write a CLAUDE.md section called `## Code Review Rules` that encodes them permanently. These should be rules Claude follows for every code review in your project, not just the ones you're explicit about each time.

## Success Criteria

- [ ] All three prompts rewritten with numbered/bulleted requirements
- [ ] Each prompt specifies output format (structure, not just content)
- [ ] Each prompt includes a "what to do if you can't complete this" instruction
- [ ] You've tested at least one rewritten prompt against Claude and compared output to the vague original
- [ ] CLAUDE.md section written with at least 5 code review rules

## Reflection Questions

- What assumptions were you making in the original prompts that you hadn't realized?
- Which type of ambiguity was hardest to spot: format, scope, or edge cases?
- Would a new team member be able to use your rewritten prompts without any additional guidance?
