# Lesson 00: Quick Start

**Goal:** Get your first meaningful result with Claude Code in 5 minutes.

This is your "hello world" for Claude Code. You'll create a simple CLAUDE.md file and see immediate improvement in how Claude works with you.

---

## Step 1: Create Your First CLAUDE.md (2 minutes)

In any project directory, create a file called `CLAUDE.md`:

```bash
cd your-project
touch CLAUDE.md
```

Add this minimal configuration:

```markdown
# My Project

[One sentence about what this project does]

## Tech Stack
- Language: [e.g., Python, TypeScript, etc.]
- Framework: [e.g., React, Django, etc.]

## Code Style
- Use [your preferred style guide]
- Never use [something you hate, e.g., `var` in JavaScript]

## Development Commands
- Run tests: `[your test command]`
- Start dev server: `[your dev command]`
```

**That's it.** Save the file.

---

## Step 2: Test It (1 minute)

Start a new Claude Code session in that directory and ask:

> "What do you know about this project?"

Claude will read your CLAUDE.md and tell you what it learned. You've just taught Claude your project's basics.

---

## Step 3: See the Difference (2 minutes)

Now ask Claude to do something simple:

> "Add a comment to the main function explaining what it does."

Notice how Claude:
- Knows where to look based on your tech stack
- Follows your code style automatically
- Doesn't ask obvious questions

**Before CLAUDE.md:** Claude would ask "What's your tech stack?" and "Where's the main function?"

**After CLAUDE.md:** Claude just does it.

---

## Your First Win 🎉

You just experienced the core concept of Claude Code mastery: **invest once in context, benefit forever**.

Every rule you add to CLAUDE.md saves you from explaining it in every future session.

---

## What's Next?

**Option 1: Keep building your CLAUDE.md** (recommended)

Spend 10 more minutes adding:
- 3 more code style rules
- Your project structure
- 3 "never do this" rules

See how Claude's behavior improves with each addition.

**Option 2: Start the full curriculum**

Jump to [Lesson 01](01-claude-md.md) for the complete guide to CLAUDE.md.

**Option 3: Solve a real problem**

Pick a simple task in your project and ask Claude to do it. Pay attention to:
- What questions does Claude ask?
- What did it misunderstand?
- What did it do wrong?

Then add rules to CLAUDE.md to prevent those issues next time.

---

## The Pattern You Just Learned

```
Notice a problem → Add a rule to CLAUDE.md → Problem never happens again
```

This is the core workflow that makes expert Claude Code users 10x more productive than beginners.

Now go to Lesson 01 to learn CLAUDE.md in depth.
