# Lesson 01: CLAUDE.md & Project Instructions

## What is CLAUDE.md?

`CLAUDE.md` is a markdown file that Claude reads automatically every time you start a session in that directory. It is the single most powerful lever you have for shaping Claude's behavior.

Claude reads CLAUDE.md files from multiple locations, in order of priority:

1. `~/.claude/CLAUDE.md` — Global rules (apply to every project)
2. `<project-root>/CLAUDE.md` — Project-level rules
3. Any CLAUDE.md found in subdirectories you're working in

Files are combined. More specific files override more general ones.

---

## What to Put in CLAUDE.md

### 1. Project Context
Tell Claude what the project is, its tech stack, and its architecture. Claude can't see everything — give it the map.

```markdown
# My Project

A SaaS billing platform built with:
- Backend: Node.js + Express + PostgreSQL
- Frontend: React + TypeScript + TailwindCSS
- Auth: JWT via Supabase
- Deployment: Docker on AWS ECS

## Architecture
- /api — Express routes
- /services — Business logic (never put DB queries here)
- /db — All database access via Prisma
- /frontend/src — React app
```

### 2. Coding Standards
Tell Claude exactly how you write code. Be opinionated.

```markdown
## Code Style
- Use TypeScript everywhere. No `any` types.
- Prefer `const` over `let`. Never `var`.
- Async/await only — no `.then()` chains.
- Error handling: always use typed error classes from /lib/errors.ts
- Imports: absolute paths using `@/` alias, not relative paths
- Tests: Vitest, not Jest. Test files colocated with source.
```

### 3. Forbidden Patterns
Explicitly ban things you never want Claude to do.

```markdown
## Never Do This
- Never use `console.log` — use the `logger` from /lib/logger.ts
- Never commit .env files
- Never add `// TODO` comments without a GitHub issue number
- Never use `any` in TypeScript
- Never write raw SQL — use Prisma
```

### 4. Workflow Instructions
Tell Claude how to work in your environment.

```markdown
## Development Workflow
- Run tests with: `bun test`
- Lint with: `bun lint`
- Always run tests after making changes
- Use conventional commits: feat:, fix:, chore:, docs:
- Never push directly to main — always create a PR
```

### 5. Important Files
Save Claude from having to hunt for critical files every session.

```markdown
## Key Files
- Database schema: /prisma/schema.prisma
- Environment variables: /docs/env-vars.md (never .env)
- API types: /types/api.ts
- Auth middleware: /middleware/auth.ts
```

---

## Global vs. Project CLAUDE.md

**Global** (`~/.claude/CLAUDE.md`) — Put preferences that are always true:
- Your communication preferences ("be concise, no emoji")
- Tools you always use (bun, not npm)
- Universal forbidden patterns
- How you like commits formatted

**Project** (`./CLAUDE.md`) — Put project-specific rules:
- Tech stack and architecture
- Project-specific commands
- Team conventions
- Codebase map

---

## Practical Exercise

Open `~/.claude/CLAUDE.md` and write your global preferences. Include:
- [ ] Your preferred package manager
- [ ] Your communication style preferences
- [ ] At least 3 "never do this" rules that apply to all your projects
- [ ] How you like commits formatted

Then create a `CLAUDE.md` in a real project and add:
- [ ] A clear description of what the project does
- [ ] The tech stack
- [ ] How to run tests
- [ ] At least 3 project-specific coding rules

---

## Pro Tips

**Keep it scannable.** Claude reads it every session. Use headers, bullets, code blocks. Dense prose is harder to parse.

**Be explicit, not implicit.** "Use good naming" is useless. "Variables should be descriptive nouns, functions should start with verbs" is actionable.

**Update it when you correct Claude.** If you find yourself telling Claude the same thing twice, it belongs in CLAUDE.md.

**CLAUDE.md is versioned code.** Commit it. Review it. Improve it over time. It gets more valuable as it grows.

**Check the token budget.** CLAUDE.md is loaded into every context. Keep your global file under ~200 lines. Long context = higher cost and potential truncation.

---

## Template

See [/templates/CLAUDE.md](../templates/CLAUDE.md) for a starter template you can copy into your projects.
