# Lesson 04: The Memory System

## How Memory Works

Claude's memory is entirely file-based. There is no magic database — it's just markdown files that get loaded into the conversation context at the start of each session.

You already have two memory systems working:

1. **`~/.claude/CLAUDE.md`** — Global instructions (always loaded)
2. **`~/.claude/projects/<project-hash>/memory/MEMORY.md`** — Project-specific persistent memory

The project memory is what Claude uses to accumulate knowledge across sessions within a single project.

---

## The Auto-Memory System

Claude Code has an auto-memory feature where Claude automatically saves important information between sessions. You can see your current memory in:

```
~/.claude/projects/<project-hash>/memory/MEMORY.md
```

Claude reads this at the start of every session and uses it to avoid re-learning things it already discovered.

---

## What Gets Saved to Memory

Claude saves (or should save) things like:

- **Architecture decisions** — "We use Repository pattern, not Active Record"
- **Key file locations** — "JWT handling is in `lib/auth/jwt.ts`"
- **Recurring solutions** — "Windows process spawning: never use Start-Process -WindowStyle Hidden"
- **User preferences** — "Ryan prefers concise responses with no emoji"
- **Gotchas discovered** — "The test suite requires Docker to be running"
- **Project conventions** — "All API endpoints return `{ data, error, meta }` format"

---

## Managing Memory Manually

### View your memory
```
Read: ~/.claude/projects/<hash>/memory/MEMORY.md
```

Or ask Claude: "Show me what's in your memory for this project."

### Add something explicitly
```
"Remember that we use Bun as our package manager, not npm."
```

Claude will update MEMORY.md.

### Correct wrong memory
```
"Forget what you saved about the database — we migrated from MySQL to PostgreSQL last month."
```

### Create topic files
For complex projects, break memory into topic files:

```
memory/
  MEMORY.md          ← index, links to other files
  architecture.md    ← system design decisions
  debugging.md       ← recurring bugs and their fixes
  patterns.md        ← code patterns used in this project
  devops.md          ← deployment, infra notes
```

In MEMORY.md, link to them:
```markdown
## Architecture
See [architecture.md](architecture.md) for full system design.
Key point: Services never call each other directly — use the event bus.
```

---

## What Makes Good Memory Entries

### Good entries are:
- **Stable** — Things that won't change next week
- **Non-obvious** — Not things Claude can figure out by reading code
- **Actionable** — Things that affect how Claude works
- **Specific** — Not "we care about performance" but "all DB queries must complete under 50ms"

### Bad entries are:
- **Transient** — "Currently working on the checkout refactor" (use your task tracker instead)
- **Redundant** — Things already in CLAUDE.md
- **Obvious** — "The project uses TypeScript" (Claude can see the files)
- **Speculative** — "We might switch to GraphQL someday"

---

## Memory vs. CLAUDE.md: Which Gets What?

| Content | Where |
|---------|-------|
| Stable coding rules | CLAUDE.md |
| Tech stack | CLAUDE.md |
| Workflow commands | CLAUDE.md |
| Things Claude discovered during work | MEMORY.md |
| Recurring bugs and fixes | MEMORY.md (debugging.md) |
| Architectural decisions made in sessions | MEMORY.md |
| User preferences stated in conversation | MEMORY.md |

If something is stable and universal, promote it from MEMORY.md to CLAUDE.md so it's explicit and versioned.

---

## The Memory Audit

Every few weeks, review your memory files:

1. **Remove stale entries** — Are they still true?
2. **Promote to CLAUDE.md** — Are some things stable enough to be rules?
3. **Break into topic files** — Is MEMORY.md getting long?
4. **Add missing context** — What has Claude re-learned that should be saved?

---

## Practical Exercise

1. Open your current `MEMORY.md` for this project and read it
2. Ask Claude: "What do you currently know about this project from memory?"
3. Tell Claude 3 things about your preferences or workflow that aren't saved yet
4. Ask Claude to save them
5. Verify the file was updated correctly
6. Try starting a new session and asking Claude to recall what it knows
