# Lesson 13: The Ralph Wiggum Technique

## What Is It?

Ralph Wiggum is the Simpsons character famous for taking everything literally. "My cat's breath smells like cat food." He doesn't infer. He doesn't read between the lines. He processes exactly what's in front of him.

The Ralph Wiggum Technique is the discipline of writing prompts so explicitly clear that even someone who takes everything literally cannot misunderstand them.

This matters because Claude is, in many ways, a very sophisticated Ralph Wiggum. It will make inferences, yes — but the inferences it makes might not be the ones you intended. The more you rely on Claude to "figure it out," the more likely you are to get something technically correct but not quite right.

---

## The Core Problem: Reasonable Assumptions

When you write a vague prompt, Claude doesn't freeze — it proceeds. It fills in the gaps with reasonable assumptions. The problem is that "reasonable" means "what most people probably want," not "what you specifically want."

Consider:

> "Refactor this function to be cleaner."

Claude will produce something. But "cleaner" is doing enormous work there. Does it mean:
- Shorter?
- More readable?
- Better variable names?
- Split into smaller functions?
- Removing nested conditionals?
- Adding comments?
- Following a specific style guide?

Claude will guess. It might guess right. But with a vague prompt, you're playing a lottery.

---

## The Solution: Leave Nothing to Inference

The Ralph Wiggum Technique has three core principles:

### 1. Explicit Over Implicit
State every constraint, every preference, every assumption. If it matters to you, write it down. Never assume Claude knows what you meant to say.

### 2. Enumerate, Don't Summarize
Instead of "make this better," list exactly what "better" means. Number your requirements. The more concrete, the more controllable.

### 3. Show, Don't Tell
When possible, provide an example of the output you want. A single example communicates more than a paragraph of description.

---

## Before and After

### Vague Prompt
> "Write me a function to validate emails."

What does that produce? Probably something using a regex. But which regex? Does it handle edge cases? Does it return a bool or throw? What language? What's the function signature?

### Ralph Wiggum Prompt
> "Write a TypeScript function called `isValidEmail` that:
> - Takes a single string parameter `email`
> - Returns `boolean` (true if valid, false otherwise)
> - Uses the regex `/^[^\s@]+@[^\s@]+\.[^\s@]+$/`
> - Does NOT throw — invalid input returns false
> - Has a JSDoc comment with one example
>
> Do not wrap it in a class. Just the function."

Now there is exactly one way to fulfill this prompt correctly.

---

### Another Example

**Vague:**
> "Review my code and suggest improvements."

**Ralph Wiggum:**
> "Review the function below. For each issue you find:
> 1. Quote the specific line(s) with the problem
> 2. Explain why it's a problem in one sentence
> 3. Show the corrected version
>
> Focus only on: correctness, error handling, and performance. Ignore style.
> If you find no issues, say 'No issues found' and stop.
> Do not add features. Do not refactor beyond what's needed to fix the issues."

The second prompt produces an actionable, structured review. The first produces whatever Claude decides a "code review" looks like.

---

## When to Use the Technique

**High-value situations:**
- Complex multi-step tasks where a wrong turn means wasted work
- Generating code that must fit a specific interface or type signature
- Any output that will be used directly (not reviewed and iterated)
- Unfamiliar domains where you can't easily spot errors
- Prompts that will be reused or productized

**Lower-value situations:**
- Exploratory conversations and brainstorming (vagueness can be generative)
- Quick questions where you'll immediately review the answer
- Tasks where you genuinely want Claude's best judgment

---

## Integration with CLAUDE.md

The Ralph Wiggum Technique isn't just for one-off prompts. Your CLAUDE.md is the place to encode your persistent Ralph Wiggum constraints — the things that are always true about how you want Claude to work.

```markdown
## Output Rules
- When writing functions, always include the full function signature with types
- When suggesting changes, show the before AND after code — never describe changes in prose only
- When you're unsure what I want, ask one specific clarifying question before proceeding
- Never add features I didn't ask for
- If a task would take more than 3 steps, confirm the plan before starting
```

Each of these rules removes an inference. Claude can no longer "reasonably" deviate from them.

> **Tip:** Every time Claude does something you didn't want, ask yourself: "What assumption did it make that I didn't explicitly forbid?" Then add that rule to CLAUDE.md.

---

## Key Takeaways

- Claude fills gaps with reasonable assumptions — your job is to have no gaps
- Vague prompts aren't just inefficient; they produce confidently wrong answers
- Enumerate your requirements: numbered lists are harder to partially fulfill than prose
- Provide output examples whenever you can — they communicate format, tone, and scope simultaneously
- CLAUDE.md is the permanent home for your Ralph Wiggum rules
- Every misunderstood prompt is a lesson: what assumption did you leave unchallenged?
