# [Project Name]

[One paragraph describing what this project is, who uses it, and what problem it solves.]

---

## Tech Stack

- **Language:** [e.g., TypeScript 5.x]
- **Runtime:** [e.g., Node.js 20 / Bun 1.x]
- **Framework:** [e.g., Express / Next.js / Fastify]
- **Database:** [e.g., PostgreSQL via Prisma]
- **Auth:** [e.g., JWT / Supabase / Auth0]
- **Testing:** [e.g., Vitest / Jest / Playwright]
- **Deployment:** [e.g., Docker on AWS ECS]

---

## Project Structure

```
/src
  /api          - [what lives here]
  /services     - [what lives here]
  /db           - [what lives here]
  /lib          - [what lives here]
  /types        - [what lives here]
/tests          - [test structure]
/docs           - [documentation]
```

### Key Files
- Entry point: [path]
- DB schema: [path]
- Environment config: [path]
- Type definitions: [path]
- Auth middleware: [path]

---

## Development Commands

```bash
# Install dependencies
[command]

# Start dev server
[command]

# Run tests
[command]

# Run tests (watch mode)
[command]

# Lint
[command]

# Type check
[command]

# Build
[command]

# DB migrations
[command]
```

---

## Code Style

- [e.g., TypeScript strict mode — no `any`]
- [e.g., Async/await only, no `.then()` chains]
- [e.g., Prefer `const`, never `var`]
- [e.g., Imports: use `@/` alias for absolute paths]
- [e.g., Error handling: use typed errors from /lib/errors.ts]

---

## Architecture Rules

- [e.g., Services never call other services directly — use events]
- [e.g., No DB queries outside of /db — all access via repository layer]
- [e.g., API routes are thin — all logic goes in services]
- [e.g., All service methods return Result<T, AppError>, never throw]

---

## Never Do This

- [e.g., Never use `console.log` — use the logger from /lib/logger.ts]
- [e.g., Never commit .env files]
- [e.g., Never push directly to main — always create a PR]
- [e.g., Never use raw SQL — use Prisma]
- [e.g., Never add `any` TypeScript type]

---

## Git Conventions

- Branch naming: `type/short-description` (e.g., `feat/add-webhooks`, `fix/payment-race`)
- Commits: conventional commits (`feat:`, `fix:`, `chore:`, `docs:`, `refactor:`, `test:`)
- PRs: require passing tests and at least 1 approval
- Never force push to main or develop

---

## Testing Standards

- Unit tests: [what to test, where to put them]
- Integration tests: [what to test, how to run]
- Coverage: [target %]
- Always run tests after making changes

---

## Additional Context

- [Link to DECISIONS.md for architectural decisions]
- [Link to SPEC.md for current sprint requirements]
- [Link to any relevant documentation]
- [Any other important context]
